--Autor: Radoslav Golian
--Popis: Skript vytvara spustac pre udalost INSERT a UPDATE nad pohladom v_card.
--       tento spustac definuje akciu, ktora sa vykona pre kazdy vkladany ci modifokovany riadok
--       :NEW, predstavuje referenciu na  nove hodnoty, ktore chceme vlozit alebo  modifikovat

CREATE OR REPLACE TRIGGER v_card_trg
  INSTEAD OF INSERT OR UPDATE ON v_card
  FOR EACH ROW
DECLARE
BEGIN
  -- kod, ktory sa vykona pri modifikovani riadku
  IF (updating) THEN
    UPDATE card
    SET    valid     = :NEW.valid,
           atm_limit = :NEW.atm_limit,
           pay_limit = :NEW.pay_limit,
           pin       = encrypt(:NEW.pin) --zasifrujeme novu hodnotu
    WHERE  id = :NEW.id;
  
  -- kod ktory sa vykona pri vkladani riadku.
  ELSIF (inserting) THEN
    INSERT INTO card
      (id, account_no, card_no, valid_thru, valid, atm_limit, pay_limit, pin)
    VALUES
      (:NEW.id,
       :NEW.account_no,
       :NEW.card_no,
       :NEW.valid_thru,
       :NEW.valid,
       :NEW.atm_limit,
       :NEW.pay_limit,
       encrypt(:NEW.pin)); --zasifrujeme vkladanu hodnotu
  END IF;
END v_card_trg;
/

